# Overview
After installing the `llmpebase` package, you can run our Staple with GPT-4 under three datasets.

Here are some examples:


#### AQUA

- Competitors
    ```console
    python examples/ChainOfThought/ChainOfThought.py -c configs/AQUA/GPT4/Fewshot_chatgpt.yml -b LLMPE
    python examples/ChainOfThought/ChainOfThought.py -c configs/AQUA/GPT4/CoT_chatgpt.yml -b LLMPE
    python examples/ChainOfThought/ChainOfThought.py -c configs/AQUA/GPT4/ZeroshotCoT_chatgpt.yml -b LLMPE

    python examples/ChainReasoning/ChainReasoning.py -c configs/AQUA/GPT4/ChainReasoning_ZeroshotCoT_chatgpt.yml -b LLMPE
    python examples/TreeReasoning/TreeReasoning.py -c configs/AQUA/GPT4/TreeLWGReasoning_ZeroshotCoT_chatgpt.yml -b LLMPE
    python examples/ThoughtRollback/ThoughtRollback.py -c configs/AQUA/GPT4/TRReasoning_ZeroshotCoT_chatgpt.yml -b LLMPE
    ```

- Staple
    ```console
    python examples/StapleReasoning/StapleOptimization.py -c configs/AQUA/GPT4/StapleReasoning_ZeroshotCoT.yml -b NIPS
    ```



#### MATH

- Competitors
    ```console
    python examples/ChainOfThought/ChainOfThought.py -c configs/MATH/GPT4/Fewshot_chatgpt.yml -b LLMPE
    python examples/ChainOfThought/ChainOfThought.py -c configs/MATH/GPT4/CoT_chatgpt.yml -b LLMPE
    python examples/ChainOfThought/ChainOfThought.py -c configs/MATH/GPT4/ZeroshotCoT_chatgpt.yml -b LLMPE
    python examples/ChainOfThought/ChainOfThought.py -c configs/MATH/GPT4/Zeroshot_chatgpt.yml -b LLMPE

    python examples/ChainReasoning/ChainReasoning.py -c configs/MATH/GPT4/ChainReasoning_ZeroshotCoT_chatgpt.yml -b LLMPE
    python examples/TreeReasoning/TreeReasoning.py -c configs/MATH/GPT4/TreeLWGReasoning_ZeroshotCoT_chatgpt.yml -b LLMPE
    python examples/ThoughtRollback/ThoughtRollback.py -c configs/MATH/GPT4/TRReasoning_ZeroshotCoT_chatgpt.yml -b LLMPE

    ```

- Staple
    ```console
    python examples/StapleReasoning/StapleOptimization.py -c configs/MATH/GPT4/StapleReasoning_ZeroshotCoT.yml -b NIPS
    ```
   

#### TheoremQA

- Competitors

    ```console
    python examples/ChainOfThought/ChainOfThought.py -c configs/TheoremQA/GPT4/Fewshot_chatgpt.yml -b LLMPE
    python examples/ChainOfThought/ChainOfThought.py -c configs/TheoremQA/GPT4/CoT_chatgpt.yml -b LLMPE
    python examples/ChainOfThought/ChainOfThought.py -c configs/TheoremQA/GPT4/ZeroshotCoT_chatgpt.yml -b LLMPE

    python examples/ChainReasoning/ChainReasoning.py -c configs/TheoremQA/GPT4/ChainReasoning_ZeroshotCoT_chatgpt.yml -b LLMPE
    python examples/TreeReasoning/TreeReasoning.py -c configs/TheoremQA/GPT4/TreeLWGReasoning_ZeroshotCoT_chatgpt.yml -b LLMPE
    python examples/ThoughtRollback/ThoughtRollback.py -c configs/TheoremQA/GPT4/TRReasoning_ZeroshotCoT_chatgpt.yml -b LLMPE
    ```
- Staple
    ```console
    python examples/StapleReasoning/StapleOptimization.py -c configs/MATH/GPT4/StapleReasoning_ZeroshotCoT.yml -b NIPS
    ```
   


